<!DOCTYPE html>
<html lang="en">
<head>
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-FEM3Q0G7NZ"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', 'G-FEM3Q0G7NZ');
    </script>
    <meta charset="UTF-8">
    <title>USC Marketplace – Create Listing</title>
    <link rel="stylesheet" href="stylesheet.css">
</head>
<body>


<header>
    <div class="wrap nav">
        <a href="LandingPage.php" class="brand"  style="color: white;">USC Student Marketplace</a>

        <nav class="links" aria-label="primary">
            <a href="about.php">About</a>
            <a href="howitworks.php">How it Works</a>
            <a href="safety.php">Safety</a>
            <a href="voices.php">Voices</a>

            <?php if (($_SESSION['is_admin'] ?? 0) == 1): ?>
                <a href="Admin_Files/index.php" class="admin-btn">Admin</a>
            <?php endif; ?>

            <a href="loginPage.php" class="cta">Log in</a>
        </nav>
    </div>
</header>

<main class="wrap">


    <section class="hero">
        <h1>Create a New Listing</h1>
        <p>Upload photos, add details, and choose a campus drop-off location.</p>
    </section>


    <section class="layout" style="grid-template-columns: 2fr 1fr;">


        <div class="filters">
            <h3>Listing Details</h3>
            <hr>

            <form action="create-listing.php" method="POST" enctype="multipart/form-data">


                <h4>Photos</h4>
                <p class="meet">Add up to 5 clear photos of your item.</p>
                <input
                        type="file"
                        id="photos"
                        name="photos[]"
                        accept="image/*"
                        multiple
                        class="w-full"
                >
                <hr>


                <h3>Title</h3>
                <label for="title" class="meet">Short and specific.</label>
                <input
                        type="text"
                        id="title"
                        name="title"
                        class="w-full"
                        placeholder="USC hoodie, iPad Pro, Econ textbook"
                        required
                >


                <hr>
                <h3>Price & Condition</h3>

                <label for="price">Price (USD)</label>
                <input
                        type="number"
                        id="price"
                        name="price"
                        class="w-full"
                        min="0"
                        step="0.01"
                        placeholder="20.00"
                        required
                >

                <label for="condition">Condition</label>
                <select id="condition" name="condition" class="w-full" required>
                    <option value="">Select condition</option>
                    <option value="new">New</option>
                    <option value="like-new">Like new</option>
                    <option value="good">Good</option>
                    <option value="fair">Fair</option>
                </select>

                <hr>

                <h3>Item Details</h3>

                <label for="category">Category</label>
                <select id="category" name="category" class="w-full" required>
                    <option value="">Choose one</option>
                    <option value="clothing">Clothing & Accessories</option>
                    <option value="electronics">Electronics</option>
                    <option value="textbooks">Textbooks</option>
                    <option value="furniture">Furniture & Decor</option>
                    <option value="tickets">Tickets & Events</option>
                    <option value="other">Other</option>
                </select>

                <label for="brand">Brand (optional)</label>
                <input type="text" id="brand" name="brand" class="w-full">

                <label for="size">Size (optional)</label>
                <input type="text" id="size" name="size" class="w-full">


                <hr>
                <h3>Description</h3>
                <label for="description" class="meet">Include condition notes, flaws, etc.</label>
                <textarea
                        id="description"
                        name="description"
                        class="w-full"
                        rows="5"
                        required
                ></textarea>


                <label for="tags">Tags (optional)</label>
                <input
                        type="text"
                        id="tags"
                        name="tags"
                        class="w-full"
                        placeholder="usc, hoodie, marshall, electronics"
                >


                <hr>
                <h3>Drop-off Location</h3>
                <p class="meet">Choose a USC campus spot for pickup.</p>

                <select id="location" name="location" class="w-full" required>
                    <option value="">Select a location</option>

                    <!-- PHP dynamic insertion -->
                    <?php
                    // foreach ($dropoffLocations as $loc) {
                    //     echo "<option value='{$loc['id']}'>{$loc['name']}</option>";
                    // }
                    ?>
                </select>


                <hr>
                <div class="actions">
                    <button type="submit" class="btn primary">Post Listing</button>
                    <button type="reset" class="btn">Clear</button>
                </div>

            </form>
        </div>


        <aside>
            <div class="card">
                <div class="thumb" id="previewThumb"></div>
                <div class="meta">
                    <p class="title">Listing Preview</p>
                    <p class="price">$0.00 <span class="badge">Preview</span></p>
                    <p class="meet">Drop-off: TBD</p>
                </div>
            </div>


        </aside>

    </section>
</main>

<footer>
    USC Marketplace · Built for students
</footer>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const fileInput = document.getElementById('photos');
        const previewThumb = document.getElementById('previewThumb');

        if (!fileInput || !previewThumb) return;

        fileInput.addEventListener('change', function () {
            const file = this.files && this.files[0];
            if (!file) {
                // If user clears the selection, remove preview
                previewThumb.style.backgroundImage = '';
                return;
            }

            const imageUrl = URL.createObjectURL(file);
            previewThumb.style.backgroundImage = "url('" + imageUrl + "')";
        });
    });
</script>


</body>
</html>