<?php
session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-FEM3Q0G7NZ"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', 'G-FEM3Q0G7NZ');
    </script>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Voices | USC Student Marketplace</title>

    <link rel="stylesheet" href="stylesheet.css">

    <style>
        .voices-hero {
            text-align: center;
            padding: 80px 20px 60px;
            margin-bottom: 60px;
        }

        .voices-hero h1 {
            font-size: clamp(32px, 5vw, 48px);
            margin: 0 0 16px 0;
            font-weight: 800;
            color: var(--cardinal);
        }

        .voices-hero p {
            font-size: clamp(16px, 2.5vw, 20px);
            max-width: 700px;
            margin: 0 auto;
            line-height: 1.6;
            color: var(--muted);
        }

        .testimonials-section {
            max-width: 900px;
            margin: 0 auto 80px;
            padding: 0 20px;
        }

        .testimonials-section h2 {
            text-align: center;
            font-size: clamp(28px, 4vw, 36px);
            margin-bottom: 50px;
            color: var(--text);
        }

        .testimonial {
            background: #fff;
            border: 1px solid var(--border);
            border-radius: var(--radius-lg);
            padding: 30px;
            margin-bottom: 24px;
            box-shadow: var(--shadow-sm);
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }

        .testimonial:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-md);
        }

        .quote {
            font-size: 18px;
            line-height: 1.7;
            color: var(--text);
            margin: 0 0 16px 0;
            font-style: italic;
            position: relative;
            padding-left: 24px;
        }

        .quote::before {
            content: '"';
            position: absolute;
            left: 0;
            top: -8px;
            font-size: 48px;
            color: var(--cardinal);
            opacity: 0.3;
            font-family: Georgia, serif;
        }

        .user {
            font-size: 14px;
            color: var(--muted);
            margin: 0;
            font-weight: 600;
        }

        .solutions-section {
            background: #fff; /* Distinct background */
            padding: 80px 20px;
            border-top: 1px solid var(--border);
        }

        .solutions-section h2 {
            text-align: center;
            font-size: clamp(28px, 4vw, 36px);
            margin: 0 auto 50px;
            max-width: 800px;
            color: var(--text);
        }

        .solutions-grid {
            max-width: 1100px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 24px;
        }

        .solution-block {
            background: var(--bg); /* Slight contrast against white section */
            border: 1px solid var(--border);
            border-radius: var(--radius-lg);
            padding: 32px;
            box-shadow: var(--shadow-sm);
            transition: transform 0.2s ease;
        }

        .solution-block:hover {
            transform: translateY(-4px);
        }

        .solution-block h3 {
            font-size: 22px;
            margin: 0 0 16px 0;
            color: var(--cardinal);
            font-weight: 700;
        }

        .solution-block p {
            font-size: 16px;
            line-height: 1.6;
            color: var(--text);
            margin: 0;
        }

        footer {
            background: #fff;
            border-top: 1px solid var(--border);
            text-align: center;
            padding: 40px 20px;
            color: var(--muted);
        }

        footer p {
            margin: 0;
            font-size: 14px;
        }
    </style>
</head>

<body>

<?php include 'nav.php'; ?>

<section class="voices-hero">
    <h1>Student Voices</h1>
    <p>Feedback from Trojans shaping a safer, more trustworthy marketplace experience.</p>
</section>

<section class="testimonials-section">
    <h2>What Students Said During Testing</h2>

    <div class="testimonial">
        <p class="quote">I finally feel like I can buy from someone without worrying if they're legit.</p>
        <p class="user">— USC Junior</p>
    </div>

    <div class="testimonial">
        <p class="quote">The layout makes way more sense than Depop or OfferUp. It's simple and feels safer.</p>
        <p class="user">— Freshman</p>
    </div>

    <div class="testimonial">
        <p class="quote">I like how everything is student-only. It reduces the sketchy meetups.</p>
        <p class="user">— Senior</p>
    </div>

    <div class="testimonial">
        <p class="quote">The detailed item page and seller badges helped me trust the person more.</p>
        <p class="user">— Sophomore</p>
    </div>
</section>

<section class="solutions-section">
    <h2>How USC Student Marketplace Solves These Problems</h2>

    <div class="solutions-grid">
        <div class="solution-block">
            <h3>✔ Trust & Confidence</h3>
            <p>
                Think-aloud testing revealed that students felt unsure about the authenticity of sellers.
                We added features like seller badges, USC verification, and clear item details to increase trust.
            </p>
        </div>

        <div class="solution-block">
            <h3>✔ Easy-to-Understand Layout</h3>
            <p>
                A/B testing showed students preferred minimal layouts with intuitive sections.
                We simplified the hierarchy, making navigation obvious and reducing decision fatigue.
            </p>
        </div>

        <div class="solution-block">
            <h3>✔ Emotional Safety & Comfort</h3>
            <p>
                Testimonials showed emotional overwhelm when buying from strangers.
                Our design uses friendly language, clear communication, and transparent seller profiles
                so users feel supported—not anxious.
            </p>
        </div>

        <div class="solution-block">
            <h3>✔ USC-Only Community</h3>
            <p>
                Students overwhelmingly felt safer knowing all buyers and sellers are Trojans.
                Closed access reduces scams, creates accountability, and mirrors the trust of a campus community.
            </p>
        </div>
    </div>
</section>

<footer>
    <p>© 2025 USC Student Marketplace · Built by Trojans for Trojans</p>
</footer>

</body>
</html>